# vol4‑mcmc‑rg‑beta

This repository combines a minimal demonstration of extracting the
one‑loop β‑function for a pure SU(N) gauge theory with an extension
that scans over different values of N.  It organises the code into
a core RG‑flow sampler and an optional SU(N) scaling analysis.

## Structure

* `requirements.txt` lists the Python dependencies (numpy, scipy,
  matplotlib).
* `scripts/` contains `extract_beta.py`, a driver for the SU(3)
  run.
* `results/` will be created by the core script to store CSV files
  and figures.
* `N_scaling/` holds the SU(N) scaling extension:
  * `scripts/extract_beta_N.py` runs the N‑scan.
  * `results/` stores the CSVs and figures for the N‑scan.
  * its own `README.md` with detailed instructions.

## Usage

1. **Install the dependencies** in a fresh environment:

   ```bash
   pip install -r requirements.txt
   ```

2. **Run the SU(3) extraction** from the repository root:

   ```bash
   python scripts/extract_beta.py
   ```

   This will populate `results/` with `g_vs_mu.csv`,
   `beta_numeric.csv` and two plots (`g_vs_lnmu.png`, `beta_fit.png`).
   The script also prints the fitted β₁ coefficient along with the
   theoretical value and relative error.

3. **Run the SU(N) scaling analysis**.  Change into the
   `N_scaling` directory and run its driver:

   ```bash
   cd N_scaling
   python scripts/extract_beta_N.py
   ```

   This produces `g_vs_mu_N.csv`, `beta_numeric_N.csv`,
   `beta1_vs_N.csv` and two figures (`beta1_scaling.png`,
   `g_vs_lnmu_N.png`) in `N_scaling/results/`.  It prints the
   fitted β₁ for each N and the relative error to the theoretical
   expectation.

All scripts are deterministic: a fixed random seed ensures
reproducibility across runs.